<?php

namespace Albedo\Auth\Services;

use Albedo\Auth\Contracts\VerifiesParticipantsInterface;
use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Exceptions\InvalidVerificationException;
use Albedo\Auth\Exceptions\VerifiedAccountException;
use Albedo\Auth\Providers\DefaultAuthUserProvider;
use Illuminate\Auth\Events\Verified;

class VerificationService implements VerifiesParticipantsInterface
{
    public function __construct(
        protected DefaultAuthUserProvider $authUserProvider,
        protected ActionCodeService $actionCodeService
    )
    {

    }

    /**
     * @throws InvalidVerificationException
     * @throws VerifiedAccountException
     */
    public function verify(array $data): void
    {
        $email = $data['email'];
        $code = $data['code'];

        $user = $this->authUserProvider->getUserModel()::query()
            ->whereEmail($email)
            ->firstOrFail();

        if ($user->hasVerifiedEmail()) {
            throw new VerifiedAccountException();
        }

        if (!$this->actionCodeService->validateAndConsume($user, ActionType::VERIFICATION_ACCOUNT, $code)) {
            throw new InvalidVerificationException();
        }

        $user->markEmailAsVerified();

        event(new Verified($user));
    }
}
