<?php

namespace Albedo\Auth\Mail;

use Albedo\Auth\Settings\AuthMailsSubjectsSettings;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ResetPasswordMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(public string $code)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: app(AuthMailsSubjectsSettings::class)->password_reset_subject,
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'auth::emails.reset-password',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
