# Albedo package auth

...

## Installation

To install this package, you need to add the following repository to your `composer.json` in your main project:

```json
"repositories": [
    {
        "type": "composer",
        "url": "https://satis.albedomarketing.net"
    }
],
```

You can install the package via composer:

```bash
composer require albedo/auth
```

To install and set up the authentication package, run the following Artisan command:

```bash
php artisan auth:install
```

## Routes

The `Albedo\Auth` package provides ready-to-use authentication endpoints.  
All routes are grouped under a prefix (`albedo-auth.route.prefix`) and alias (`albedo-auth.route.as`) from the config.

### Public Routes (No Authentication Required)

| Method | URI | Controller | Route Name | Description |
|--------|-----|------------|------------|-------------|
| POST   | `/login` | `LoginAction` | `login` | User login |
| POST   | `/register` | `RegisterAction` | `register` | Register a new user |
| POST   | `/forgot-password` | `RemindPasswordAction` | `forgot-password` | Send password reset link |
| POST   | `/verification-reset-password` | `VerificationCodeResetPasswordAction` | `verification-reset-password` | Verify code for password reset |
| POST   | `/reset-password` | `ResetPasswordAction` | `password-reset` | Reset user password |
| POST   | `/account-verification` | `VerificationAction` | `account-verification` | Verify user account |

### Authenticated Routes (Require Sanctum)

| Method | URI | Controller | Route Name | Description |
|--------|-----|------------|------------|-------------|
| POST   | `/logout` | `LogoutAction` | `logout` | Log out the user |
| POST   | `/change-password` | `ChangePasswordAction` | `change-password` | Change password for logged-in user |
| GET    | `/profile` | `ProfileAction` | `profile` | Get profile of logged-in user |

> All authenticated routes use middleware defined in `albedo-auth.authentication.route.middleware`.
