<?php

namespace Albedo\Auth\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegistrationCodeMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(
        public string $code,
    ) {}

    public function build(): self
    {
        return $this->subject('Verify your account')
            ->view('albedo-auth::emails.verification-account')
            ->with([
                'code' => $this->code,
            ]);
    }
}


