<?php

namespace Albedo\Auth\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UserResetPasswordRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'email' => 'required|email',
            'code' => ['required'],
            'password' => ['required', 'confirmed', 'max:255', Password::defaults()],
            'password_confirmation' => 'required|same:password'
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
