<?php

namespace Albedo\Auth\Http\Requests;

use App\Services\AgreementService;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class RegisterRequest extends FormRequest
{
    public function rules(): array
    {
        return [

            'first_name' => [
                'required',
                'string',
                'min:3',
                'max:30',
            ],

            'last_name' => [
                'required',
                'string',
                'min:3',
                'max:30',
            ],

            'email' => [
                'required',
                'string',
                'confirmed',
                'unique:users,email',
                'email:rfc,dns',
                'max:255',
            ],

            'phone_number' => ['required'],

            'password' => [
                'required',
                'confirmed',
                'max:255',
                Password::defaults()
            ],

            'password_confirmation' => ['required', 'same:password'],
            'avatar_id' => ['required'],
        ];
    }

    private function getAgreementsRule(): array
    {
        return collect(AgreementService::prepareAgreementsList())
            ->mapWithKeys(function ($value, $key) {

                $rule = ['required', 'boolean', 'present'];

                if ($value['must_be_accepted']) {
                    $rule[] = 'accepted';
                }

                return [$key => $rule];

            })->toArray();
    }

    public function authorize(): bool
    {
        return true;
    }
}
