<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Http\Requests\UserResetPasswordRequest;
use Albedo\Auth\Services\ActionCodeService;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Str;

class ResetPasswordAction extends Controller
{
    public function __construct(protected ActionCodeService $actionCodeService)
    {

    }
    public function __invoke(UserResetPasswordRequest $request): JsonResponse
    {
        $user = app(config('albedo-auth.user_model'))::query()
            ->whereEmail($request->email)
            ->first();

        if (is_null($user)) {
            Response::error(
                message: 'User has not been found.'
            );
        }

        $code =  $request->input('code');

        if (! $this->actionCodeService->validateAndConsume($user, ActionType::RESET_PASSWORD, $code)) {
            return Response::error(
                message: __('Invalid or expired code.'), status: 422
            );
        }

        $user->forceFill([
            'password' => Hash::make($request->password)
        ])
            ->setRememberToken(Str::random(60));

        $user->save();

        event(new PasswordReset($user));

        return Response::success(
            message: __('Password has been changed.'),
        );


    }
}
