<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Http\Requests\RemindPasswordRequest;
use Albedo\Auth\Mail\ResetPasswordMail;
use Albedo\Auth\ResetPasswordCodeService;
use Albedo\Auth\Services\ActionCodeService;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Response;

class RemindPasswordAction extends Controller
{
    public function __construct(protected ActionCodeService $actionCodeService)
    {
    }

    public function __invoke(RemindPasswordRequest $request)
    {
        $email = request()->input('email');

        $user = app(config('albedo-auth.user_model'))::query()
            ->whereEmail($email)
            ->first();

        if (is_null($user)) {
            return $this->responseSuccess();
        }

        $actionCode = $this->actionCodeService->generate($user, ActionType::RESET_PASSWORD);

        Mail::to($user->email)->queue(new ResetPasswordMail($actionCode->code));

        return $this->responseSuccess();
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function responseSuccess(): \Illuminate\Http\JsonResponse
    {
        return Response::success(
            message: __('If the provided email address exists in our system, we will send instructions to reset your password.')
        );
    }
}
