<?php

namespace Albedo\Auth\Http\Controllers;

use Exception;
use Illuminate\Support\Facades\Response;

class LogoutAction extends Controller
{
    public function __invoke()
    {
        $user = auth()->user();

        if (!$user) {
            return Response::error(message: 'Not authenticated.', status: 401);
        }

        try {
            $user->tokens()->delete();
            return Response::success(message: 'Logout successful.');
        } catch (Exception $e) {
            report($e);
            return Response::error(message: 'Logout failed.', status: 500);
        }
    }
}
