<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Requests\UserChangePasswordRequest;
use Exception;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Facades\Response;

class ChangePasswordAction extends Controller
{
    public function __construct(protected Authenticatable $user)
    {
    }

    public function __invoke(UserChangePasswordRequest $request)
    {
        try {

            $this->user->update(['password' => bcrypt($request->password)]);

            return Response::success(message: 'Password changed successfully.');
        } catch (Exception $e) {
            report($e);
            return Response::error(message: 'Failed to change password.');
        }
    }
}
