<?php

namespace Albedo\Auth\Services;

use Albedo\Auth\Contracts\LogsOutParticipantsInterface;
use Albedo\Auth\Providers\DefaultAuthUserProvider;

class LogoutService implements LogsOutParticipantsInterface
{
    public function __construct(protected DefaultAuthUserProvider $authUserProvider)
    {
    }
    public function logout(?string $tokenName = null): void
    {
        $user = $this->authUserProvider->getCurrentUser();

        if ($user && $user->currentAccessToken()) {
            $user->currentAccessToken()?->delete();
        }
    }

    public function logoutFromAllDevices(): void
    {
        auth()->user()?->tokens()->delete();
    }
}
