<?php

namespace Albedo\Auth\Http\Requests;

use Albedo\Gamification\Services\AgreementService;
use Albedo\Gamification\Services\AvatarService;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class RegisterRequest extends FormRequest
{

    public function rules(): array
    {
        $agreementService = app(AgreementService::class);
        $avatarService = app(AvatarService::class);

        return [
            'first_name' => ['required', 'string', 'min:3', 'max:30'],
            'last_name'  => ['required', 'string', 'min:3', 'max:30'],
            'email'      => ['required', 'string', 'confirmed', 'email:rfc,dns', 'max:255'],
            'phone_number' => ['required'],
            'password'   => [
                'required',
                'confirmed',
                'max:255',
                Password::min(12)
                    ->numbers()
                    ->mixedCase()
                    ->symbols()
            ],
            'password_confirmation' => ['required', 'same:password'],
            ...$agreementService->getAgreementRules(),
            ...$avatarService->getAvatarRules(),
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
