<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Contracts\LogsOutParticipantsInterface;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

/**
 * Akcja wylogowania użytkownika.
 *
 * @group Autoryzacja
 * Endpoint do wylogowania aktualnie zalogowanego użytkownika i unieważnienia tokenów.
 *
 * @authenticated
 * @response 200 {"message": "Logout successful."}
 * @response 401 {"message": "Not authenticated."}
 */
class LogoutAction extends Controller
{
    public function __construct(protected LogsOutParticipantsInterface $authService)
    {
    }

    /**
     * Wylogowuje użytkownika i usuwa wszystkie tokeny.
     *
     * @response 200 {"message": "Logout successful."}
     * @response 401 {"message": "Not authenticated."}
     */
    public function __invoke()
    {
        try {
            $this->authService->logout();
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }

        return Response::success(message: 'Logout successful.');
    }
}
