<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Requests\RegisterRequest;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Response;

/**
 * Rejestracja nowego użytkownika.
 *
 * @group Rejestracja
 * Endpoint rejestrujący nowego użytkownika w systemie.
 *
 * @bodyParam first_name string required Imię. Example: Jan
 * @bodyParam last_name string required Nazwisko. Example: Kowalski
 * @bodyParam email string required Adres e-mail. Example: j.kowalski@domena.pl
 * @bodyParam phone_number string required Numer telefonu użytkownika. Example: 123456789
 * @bodyParam password string required Hasło. Example: SilneHasło123!
 * @bodyParam password_confirmation string required Potwierdzenie hasła. Example: SilneHasło123!
 * @bodyParam avatar_id integer required Avatar użytkownika (ID). Example: 1
 *
 * @response 200 {"message": "Register successful."}
 */
class RegisterAction extends Controller
{
    /**
     * Rejestracja nowego użytkownika.
     *
     * @group Rejestracja
     * Endpoint rejestrujący nowego użytkownika w systemie.
     *
     * @bodyParam first_name string required Imię. Example: Jan
     * @bodyParam last_name string required Nazwisko. Example: Kowalski
     * @bodyParam email string required Adres e-mail. Example: j.kowalski@domena.pl
     * @bodyParam phone_number string required Numer telefonu użytkownika. Example: 123456789
     * @bodyParam password string required Hasło. Example: SilneHasło123!
     * @bodyParam password_confirmation string required Potwierdzenie hasła. Example: SilneHasło123!
     * @bodyParam avatar_id integer required Avatar użytkownika (ID). Example: 1
     * @bodyParam {zgoda} boolean required Akceptacja zgody (np. regulations). Example: true
     *
     * @response 200 {"message": "Register successful."}
     */
    public function __invoke(RegisterRequest $request)
    {
        $user = app(config('albedo-auth.user_model'))::query()
            ->create([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'password' => $request->password,
            ]);

        event(new Registered($user));


        return Response::success(
            message: 'Register successful.',
        );
    }
}
