<?php

namespace Albedo\Auth\Http\Controllers;

use Exception;
use Illuminate\Support\Facades\Response;

/**
 * Akcja wylogowania użytkownika.
 *
 * @group Autoryzacja
 * Endpoint do wylogowania aktualnie zalogowanego użytkownika i unieważnienia tokenów.
 *
 * @authenticated
 * @response 200 {"message": "Logout successful."}
 * @response 401 {"message": "Not authenticated."}
 */
class LogoutAction extends Controller
{
    /**
     * Wylogowuje użytkownika i usuwa wszystkie tokeny.
     *
     * @response 200 {"message": "Logout successful."}
     * @response 401 {"message": "Not authenticated."}
     */
    public function __invoke()
    {
        $user = auth()->user();

        if (!$user) {
            return Response::error(message: 'Not authenticated.', status: 401);
        }

        try {
            $user->tokens()->delete();
            return Response::success(message: 'Logout successful.');
        } catch (Exception $e) {
            report($e);
            return Response::error(message: 'Logout failed.', status: 500);
        }
    }
}
