<?php

namespace Albedo\Auth;

use Albedo\Auth\Commands\AuthCommand;
use Albedo\Auth\Contracts\LogsInParticipantsInterface;
use Albedo\Auth\Contracts\LogsOutParticipantsInterface;
use Albedo\Auth\Contracts\ProfileParticipantInterface;
use Albedo\Auth\Contracts\RecoversParticipantPasswordsInterface;
use Albedo\Auth\Contracts\RegistersParticipantsInterface;
use Albedo\Auth\Contracts\VerifiesParticipantsInterface;
use Albedo\Auth\Services\LoginService;
use Albedo\Auth\Services\LogoutService;
use Albedo\Auth\Services\PasswordRecoveryService;
use Albedo\Auth\Services\ProfileService;
use Albedo\Auth\Services\RegisterService;
use Albedo\Auth\Services\VerificationService;
use Illuminate\Support\Facades\Event;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class AuthServiceProvider extends PackageServiceProvider
{

    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('auth')
            ->hasConfigFile('albedo-auth')
            ->hasViews()
            ->hasMigrations([
                'create_auth_table',
                '2025_10_08_000000_create_action_codes_table',
            ])
            ->runsMigrations()
            ->hasRoute('auth')
            ->hasCommand(AuthCommand::class);
    }

    public function packageBooted(): void
    {
        Event::listen(
            \Illuminate\Auth\Events\Registered::class,
            \Albedo\Auth\Listeners\SendVerificationCodeOnRegistrationListener::class
        );

        $this->app->bind(RegistersParticipantsInterface::class, RegisterService::class);
        $this->app->bind(LogsInParticipantsInterface::class, LoginService::class);
        $this->app->bind(LogsOutParticipantsInterface::class, LogoutService::class);
        $this->app->bind(RecoversParticipantPasswordsInterface::class, PasswordRecoveryService::class);
        $this->app->bind(VerifiesParticipantsInterface::class, VerificationService::class);
        $this->app->bind(ProfileParticipantInterface::class, ProfileService::class);


    }
}
