<?php

namespace Albedo\Auth\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Str;
use Ramsey\Uuid\Uuid;

class AnonymizeDeletedUsersCommand extends Command
{
    protected $signature = 'auth:anonymize-deleted-users';

    protected $description = 'Command description';

    public function handle(): int
    {
        $user = config('albedo-auth.user_model');
        $anonymizationDelay = config('albedo-auth.user_anonymization_delay');

        $user::query()
            ->onlyTrashed()
            ->whereNull('anonymized_at')
            ->where('deleted_at', '<=', now()->sub($anonymizationDelay))
            ->chunkById(100, function ($users) {
                $users->each(function ($user) {
                    $user->forceFill([
                        'email' => strtolower(sprintf('%s@' . __('Deleted') . '.' . __('Deleted'), Uuid::uuid4())),
                        'password' => Str::random(32),
                        'first_name' => __('Deleted'),
                        'last_name' => __('Deleted'),
                        'anonymized_at' => now(),
                    ]);
                    $user->save();
                });
            });

        $this->info('Anonymization completed.');

        return self::SUCCESS;
    }
}
