<?php

namespace Albedo\Auth\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UserResetPasswordRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'email' => ['required', 'string', 'email', 'max:255'],
            'token' => ['required'],
            'password' => ['required', 'confirmed', 'max:255', Password::defaults()],
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
