<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Requests\RemindPasswordRequest;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Response;

class RemindPasswordAction extends Controller
{
    public function __invoke(RemindPasswordRequest $request)
    {
        $email = request('email');

        $user = app(config('albedo_auth.user_model'))::query()
            ->whereEmail($email)
            ->first();

        if (is_null($user)) {
            return Response::error(message: __('User has not been found.'), status: 404);
        }

        if (!$user->hasVerifiedEmail()) {
            return Response::error(message: __('Account has not been verified.'), status: 403);
        }

        $status = Password::sendResetLink(['email' => $email]);

        // TODO przenieść do odpowiedniego miejsca
        Log::info(sprintf('Password reset link has been sent to "%s". Status: %s', $email,
            $status === Password::RESET_LINK_SENT ? 'sent' : 'failed'
        ));

        return Response::success(
            message: __('Password reset link has been successfully sent.'),
        );
    }
}
