<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Http\Requests\VerificationCodeResetPasswordRequest;
use Albedo\Auth\Services\ActionCodeService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Str;

class VerificationCodeResetPasswordAction extends Controller
{

    public function __construct(protected ActionCodeService $actionCodeService)
    {

    }
    public function __invoke(VerificationCodeResetPasswordRequest $request)
    {
        $user = app(config('albedo-auth.user_model'))::query()
            ->whereEmail($request->email)
            ->first();

        if (is_null($user)) {
            return Response::error(
                message: 'User has not been found.'
            );
        }

        $code = $request->input('code');

        if (!$this->actionCodeService->validateAndConsume($user, ActionType::RESET_PASSWORD, $code)) {
            return Response::error(
                message: __('Invalid or expired code.'), status: 422
            );
        }

        $token = Str::random(64);

        DB::table('password_reset_tokens')->where('email', $user->email)->delete();

        DB::table('password_reset_tokens')->insert([
            'email' => $user->email,
            'token' => Hash::make($token),
            'created_at' => now(),
        ]);

        return Response::success(
            data: ['token' => $token],
            message: __('Password reset token generated successfully.'),
        );
    }
}
