<?php

namespace Albedo\Auth;

use Albedo\Auth\Listeners\SendVerificationCodeOnRegistrationListener;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Event;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use Albedo\Auth\Commands\AuthCommand;

class AuthServiceProvider extends PackageServiceProvider
{

    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('auth')
            ->hasConfigFile('albedo-auth')
            ->hasViews()
            ->hasMigrations([
                'create_auth_table',
                '2025_10_08_000000_create_action_codes_table',
            ])
            ->runsMigrations()
            ->hasRoute('auth')
            ->hasCommand(AuthCommand::class);
    }

    public function packageBooted(): void
    {
        Event::listen(
            Registered::class,
            SendVerificationCodeOnRegistrationListener::class,
        );
    }
}
