<?php

namespace Albedo\Auth\Models\Traits;

use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasBasicInfo
{
    public function getBasicInfo(): array
    {
        return [
            'id' => $this->getKey(),
            'email' => $this->getAttribute('email'),
            'name' => $this->getFullName(),
            'first_name' => $this->getFirstName(),
            'last_name' => $this->getLastName()
        ];
    }

    public function getPublicInfo(): array
    {
        return [
            'id' => $this->getKey(),
            'email' => $this->getAttribute('email'),
            'name' => $this->getShortName(),
            'first_name' => $this->getFirstName(),
            'last_name' => $this->getShortLastName()
        ];
    }

    public function censoredName(): Attribute
    {
        return Attribute::make(
            get: fn() => mb_ucfirst($this->first_name) . ' ' . mb_ucfirst(mb_substr($this->last_name, 0, 1)) . ".",
        );
    }
}
