<?php

namespace Albedo\Auth\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class UserChangePasswordRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'old_password' => [
                'required',
                fn($attribute, $value, $fail) => Hash::check($value, request()->user()->password) ?: $fail(__('The provided old password was incorrect.')),
            ],
            'password' => [
                'required',
                'same:password_confirmation',
                Password::min(12)
                    ->numbers()
                    ->mixedCase()
                    ->symbols()
            ],
            'password_confirmation' => [
                'required',
                'same:password',
                Password::min(12)
                    ->numbers()
                    ->mixedCase()
                    ->symbols()
            ],
        ];
    }

    public function messages()
    {
        return config('albedo-auth.custom_validation_messages.user_change_password') ?? parent::messages();
    }
}
