<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Contracts\ProfileParticipantInterface;
use Albedo\Auth\Http\Resources\ParticipantResource;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

/**
 * Pobiera profil bieżącego użytkownika.
 *
 * @group Zarządzanie kontem
 * Endpoint do pobrania danych aktualnie zalogowanego użytkownika.
 *
 * @authenticated
 * @response 200 {"data": {"id": 1, "email": "jankowalski@domena.pl"}} !!ELEMENT DO ROZBUDOWY!!
 * @response 500 {"message": "Failed to get profile."}
 */
class ProfileAction extends Controller
{
    public function __construct(protected ProfileParticipantInterface $authService)
    {
    }

    /**
     * Zwraca dane profilowe aktualnie zalogowanego użytkownika.
     *
     * @response 200 {"data": {"id": 1, "email": "jankowalski@domena.pl"}}
     * @response 500 {"message": "Failed to get profile."}
     */
    public function __invoke(Request $request)
    {
        try{
            $participant = $this->authService->getParticipantProfile($request->user());
        }catch(Exception $e){
            report($e);
            return Response::generalError();
        }

        return Response::success(
            data: new ParticipantResource($participant)
        );
    }
}
