<?php

namespace Albedo\Auth\Http\Controllers;

use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class VerificationAction extends Controller
{
    public function __invoke(Request $request)
    {
        try {
            $user = app(config('albedo-auth.user_model'))::query()
                ->findOrFail($request->query('id'));

            if (! $request->hasValidSignature()) {
                throw new AuthorizationException('The link is invalid or has expired.');
            }

            if (!hash_equals($request->query('hash'), sha1($user->getEmailForVerification()))) {
                throw new AuthorizationException('Error. Unable to verify account.');
            }

            if ($user->hasVerifiedEmail()) {
                throw new AuthorizationException('The account has already been verified.');
            }

            $user->markEmailAsVerified();

            event(new Verified($user));

            return Response::success(
                message: 'Your account has been verified.',
            );
        } catch (AuthorizationException $ex) {
            return Response::error(
                message: $ex->getMessage(),
                status: 409
            );
        } catch (Exception $ex) {
            report($ex);
            return Response::generalError();
        }
    }
}
