<?php

namespace Albedo\Auth\Http\Controllers;

use Albedo\Auth\Http\Requests\RegisterRequest;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Response;

class RegisterAction extends Controller
{
    public function __invoke(RegisterRequest $request)
    {
        $user = app(config('albedo-auth.user_model'))::query()
            ->create([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'password' => $request->password,
            ]);

        event(new Registered($user));

        return Response::success(
            message: 'Register successful.',
        );
    }
}
