<?php

namespace Albedo\Auth;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use Albedo\Auth\Commands\AuthCommand;

class AuthServiceProvider extends PackageServiceProvider
{

    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('auth')
            ->hasConfigFile('albedo-auth')
            ->hasViews()
            ->hasMigrations([
                'create_auth_table',
            ])
            ->runsMigrations()
            ->hasRoute('auth')
            ->hasCommand(AuthCommand::class);
    }
}
