<?php

return [

    'user_model' => App\Models\User::class,

    'route' => [
        'as' => 'auth.',
        'prefix' => 'api',
        'middleware' => [
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ],

    'authentication' => [
        'route' => [
            'middleware' => [
                \Illuminate\Routing\Middleware\SubstituteBindings::class,
                'auth:sanctum'
            ],
        ],
    ],

    'password_reset_token_expires_in' => 3600,

    'user_unverified_lifetime' => '1 day',

    'user_anonymization_delay' => '7 days',

    'recaptcha_enabled' => env('ALBEDO_AUTH_RECAPTCHA_ENABLED', 1),

    'custom_validation_messages' => [
        'login' => [
//            Example
//            'login.required' => 'Please enter your login.',
//            'password.max' => 'Password must be at least :max characters.',
        ],
        'register' => [

        ],
        'remind_password' => [

        ],
        'user_change_password' => [

        ],
        'user_reset_password' => [

        ],
        'verification_code_reset_password' => [

        ],
        'verification' => [

        ]
    ]

];

