<?php

namespace Albedo\Auth\Listeners;

use Albedo\Auth\Enums\ActionType;
use Albedo\Auth\Mail\RegistrationCodeMail;
use Albedo\Auth\Services\ActionCodeService;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Mail;

class SendVerificationCodeOnRegistrationListener
{
    public function __construct(protected ActionCodeService $actionCodeService)
    {
    }

    public function handle(Registered $event): void
    {
        $actionCode = $this->actionCodeService->generate(
            $event->user,
            ActionType::VERIFICATION_ACCOUNT,
            60
        );

        Mail::to($event->user->email)
            ->queue(new RegistrationCodeMail($actionCode->code));
    }
}
